
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// basic structure | grundlegende struktur

//////// global variables | variablen, ueberall gueltig
float grayscale = .1;                   // superordinate background grayscale value | uebergeordnet gesetzter grauwert des hintergrunds

//////// setup, runs once at startup | setup, anfaenglich einmal aufgefuehrt
void setup() {
  size( 1280, 720 );                    // size of the window | groesse des fensters
  pixelDensity( displayDensity() );     // control depiction depending on screen | darstellung in abhaengigkeit zum bildschirm festlegen
  frameRate( 2 );                       // repetition rate of draw | wiederholungsrate von draw()
  strokeWeight( 24 );                   // size of the point | die punktgroesse
  stroke( 255*grayscale );              // inverted grayscale of the point | der 'invertierte' grauwert des punkts
}

//////// draw, runs repeatedly afterwards | draw, wird automatisch immer wieder ausgefuehrt 
void draw() {
  background( 255*(1-grayscale) );      // grayscale of the background | der grauwert des hintergrunds
  point( random(0, width), height/2 );  // point at random x-position | punkt mit zufaelliger x-position
}
