
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// dots step 3 corner | punkte schritt 3 ecke

//////// variables
float[] dots_y;
float[] dots_w;

//////// setup
void setup() {
  size( 1280, 720 );
  //fullScreen();
  dots_y = new float[0];
  dots_w = new float[0];
  for ( int d=0; d<8; d++ ) {
    genData();
  }
}

//////// draw
void draw() {
  background( 255 );
  for ( int d=0; d<dots_y.length; d++ ) {
    strokeWeight( dots_w[d] );
    line( 0, mouseY, mouseX, dots_y[d] );       // lines from the left | linien von links
    line( width, mouseY, mouseX, dots_y[d] );   // lines from the right | linien von rechts
  }
  float min_y = sort(dots_y)[0];                // getting the smallest number, therefore the top of the corner | niedrigste zahl und damit die spitze der kante 
  float max_y = sort(dots_y)[dots_y.length-1];  // getting the smallest number, therefore the bottom of the corner | hoechste zahl und damit das ende der kante
  strokeWeight( width/256 );
  line( mouseX, min_y, mouseX, max_y );         // line for the corner | linie fuer die kante
}

//////// interaction, via keyboard | interaktion, via tastatur
void keyPressed() {
  if ( key=='a' ) {
    genData();
  }
  if ( key=='s' ) {
    setup();
  }
  print( "current frame: " + frameCount );
  print( " overall dots: " + dots_y.length );
  print( "\n" );
}

//////// functions, selfdefined | funktionen, selbstdefiniert
void genData() {
  dots_y = append( dots_y, random(0,height) );
  dots_w = append( dots_w, random(1,width/64) );
}
