
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// dots step 4 stars | punkte schritt 4 sterne

//////// variables
float[] dots_x;
float[] dots_y;
float[] dots_t;
float[] dots_w;

//////// setup
void setup() {
  size( 1280, 720 );
  //fullScreen();
  dots_x = new float[0];
  dots_y = new float[0];
  dots_t = new float[0];
  dots_w = new float[0];
  for ( int d=0; d<32; d++ ) {                  // some more dots | einige punkte mehr
    genData();
  }
}

//////// draw
void draw() {
  background( 0, 0, 32 );                       // darkblue sky | dunkelblauer himmel
  for ( int d=0; d<dots_x.length; d++ ) {
    stroke( 255, dots_t[d] );                   // glowing stars | leuchtende sterne
    strokeWeight( dots_w[d] );
    point( dots_x[d], dots_y[d] );
  }
  edtData();                                    // calling the function to edit data | funktion zum aendern der daten aufrufen
}

//////// interaction
void keyPressed() {
  if ( key=='a' ) {
    genData();
  }
  if ( key=='s' ) {
    setup();
  }
  print( "current frame: " + frameCount );
  print( " overall dots: " + dots_x.length );
  print( "\n" );
}

//////// functions
void genData() {
  dots_x = append( dots_x, random(0,width) );
  dots_y = append( dots_y, random(0,height) );
  dots_t = append( dots_t, random(0,255) );
  dots_w = append( dots_w, random(1,width/64) );
}
void edtData() {                                // name the fuction | name der funktion
  for ( int d=0; d<dots_x.length; d++ ) {       // looping all dots | alle punkte durcharbeiten
    dots_t[d] += random( -4, 4 );               // changing the transparency | transparenz veraendern
    dots_t[d] = constrain( dots_t[d], 8, 248 ); // setting upper and lower limits | unteres und oberes limit setzen
  }  
}
