
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// dots step 5 night sky | punkte schritt 5 nachthimmel

//////// variables
float[] dots_x;
float[] dots_y;
float[] dots_t;
float[] dots_w;

//////// setup
void setup() {
  size( 1280, 720 );
  //fullScreen();
  dots_x = new float[0];
  dots_y = new float[0];
  dots_t = new float[0];
  dots_w = new float[0];
  for ( int d=0; d<512; d++ ) {                         // even more dots | sogar noch mehr punkte
    genData();
  }
}

//////// draw
void draw() {
  background( 0, 0, 32 );
  translate( mouseX, mouseY );                          // translate coordinate-origin | koordinatenursprung verschieben
  rotate( frameCount * -.0002 );                        // rotate canvas around origin | zeichenflaeche um den ursprung drehen
  for ( int d=0; d<dots_x.length; d++ ) {
    stroke( 255, dots_t[d] );
    strokeWeight( dots_w[d] );
    point( dots_x[d], dots_y[d] );
  }
  edtData();
}

//////// interaction
void keyPressed() {
  if ( key=='a' ) {
    genData();
  }
  if ( key=='s' ) {
    setup();
  }
  print( "current frame: " + frameCount );
  print( " overall dots: " + dots_x.length );
  print( "\n" );
}

//////// functions
void genData() {
  dots_x = append( dots_x, random(-width,width) );      // rearrange distribution | verteilung neu anpassen
  dots_y = append( dots_y, random(-width,width) );      // rearrange distribution | verteilung neu anpassen
  dots_t = append( dots_t, random(0,255) );
  dots_w = append( dots_w, random(1,width/64) );
}
void edtData() {
  for ( int d=0; d<dots_x.length; d++ ) {
    dots_t[d] += random( -5, 5 );
    dots_t[d] = constrain( dots_t[d], 8, 248 );
  }  
}
