
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
// ! DO NOT EDIT unless you know exactly what you are doing ! //
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

//////////////////////////////// NECESSARY SETUP

//////// import
import processing.data.JSONObject;

//////// global variables
JSONObject json;

//////// load the json file
float[] loadMeteoJson( float json_latitude, float json_longitude, int json_days, String json_name ) {
  //////// constrain arguments
  json_latitude = constrain( json_latitude, -90, 90 );
  json_longitude = constrain( json_longitude, -180, 180 );
  json_days = constrain( json_days, 1, 16 );
  //////// gather query and load data
  String query = "https://api.open-meteo.com/v1/forecast";
  query += "?latitude=" + json_latitude;
  query += "&longitude=" + json_longitude;
  query += "&hourly=" + json_name;
  query += "&timezone=auto";
  query += "&forecast_days=" + json_days;
  json = loadJSONObject( query );
  //////// print basic info
  print( "weather prediction DATA: \"" + json_name + "\" for today" );
  if( json_days==2 ) print( " and tomorrow" );
  if( json_days>2 ) print( " and the next " + (json_days-1) + " days" );
  println( ", grabbed at https://open-meteo.com/" );
  print( "from: " + nfp(json.getFloat("latitude"),3,3) +  "/" + nfp(json.getFloat("longitude"),3,3) + " latitude/longitude" );
  print( ", elevation " + nfp(json.getFloat("elevation"),4,0) );
  print( ", timezone " + json.getString("timezone") );
  println( " (" + json.getString("timezone_abbreviation") + ")" );
  //////// read in and return data
  float[] items = new float[0];
  JSONObject json_hourly = json.getJSONObject( "hourly" );
  JSONArray json_items = json_hourly.getJSONArray( json_name );
  for (int i=0; i<json_items.size(); i++)
    items = append( items, json_items.getFloat(i) );
  return items;
}

//////////////////////////////// USEFUL FUNCTIONS

//////// return the corresponding timeframe
String[] getMeteoTime() {
  String[] items = new String[0];
  JSONObject json_hourly = json.getJSONObject( "hourly" );
  JSONArray json_items = json_hourly.getJSONArray( "time" );
  for (int i=0; i<json_items.size(); i++)
    items = append( items, json_items.getString(i).replace('T',' ') );
  return items;
}

//////// draw simple demo output
void simpleDemo( float[] dat ) {
  //////// additional data
  String[] tim = getMeteoTime();
  //////// depiction
  textSize( height/dat.length );
  strokeWeight( height/128 );
  stroke( 255 );
  float[] dat_srt = sort( dat );
  float dat_min = dat_srt[0] - .1;
  float dat_max = dat_srt[dat_srt.length-1] + .1;
  //dat_min = -100;
  //dat_max = 100;
  for( int d=0; d<dat.length; d++ ) {
    float xpos = map( d, 0, dat.length-1, width*.05, width*.95 ); ;
    float ypos = map( dat[d], dat_min, dat_max, height*.9, height*.1 );
    float pos0 = map( 0, dat_min, dat_max, height*.9, height*.1 );
    float col = map( dat[d], dat_min, dat_max, 255*.1, 255*.9 );
    strokeWeight( 1 );
    stroke( col, 0, 0 );
    line( xpos, ypos, xpos, pos0 );
    fill( col, 0, 0 );
    textAlign( CENTER, BOTTOM );
    text( dat[d]+"", xpos, ypos );
    if( d%6==0 ) {
      stroke( 255*.5 );
      line( xpos, 0, xpos, height*.05 );
      fill( 255*.5 );
      textAlign( LEFT, TOP );
      text( " "+tim[d], xpos, 0 );
    }
  }
}

//////// save image
void savePng() {
  //////// naming
  println( "    #### starting to export png image ..." );
  String png_name = "pngs/" + getClass().getSimpleName() + "_" + str(year()).substring(2) + nf(month(), 2) + nf(day(), 2) + "_" + nf(hour(), 2) + nf(minute(), 2) + nf(second(), 2);
  //////// saving
  save( png_name  + ".png" );
  println( png_name + ".png" + " saved!\n" );
}
