
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// path step 1

/*
  variable-documentation and data from:
  https://open-meteo.com/en/docs
  
  use *FUNCTION* to gather weather data, will return float array:
  loadMeteoJson( latitude, longitude, days, weather variables );
  
  : latitude (float)
  -90 to 90, south to north, eg. 47.07 for graz
  : longitude (float)
  -180 to 180, west to east, eg. 15.44 for graz
  : days (int)
  1 to 16
  : most common weather variables (string)
  "temperature_2m","relative_humidity_2m","dew_point_2m","apparent_temperature",
  "precipitation_probability","precipitation","rain","showers","snowfall",
  "weather_code","pressure_msl","surface_pressure","cloud_cover",
  "cloud_cover_low","cloud_cover_mid","snow_depth","cloud_cover_high",
  "visibility","evapotranspiration","et0_fao_evapotranspiration",
  "vapour_pressure_deficit","wind_speed_10m","wind_speed_80m","wind_speed_120m",
  "wind_speed_180m","wind_direction_10m","wind_direction_80m",
  "wind_direction_120m","wind_direction_180m","wind_gusts_10m","temperature_80m",
  "temperature_120m","temperature_180m","soil_temperature_0cm",
  "soil_temperature_6cm","soil_temperature_18cm","soil_temperature_54cm",
  "soil_moisture_0_to_1cm","soil_moisture_1_to_3cm","soil_moisture_3_to_9cm",
  "soil_moisture_9_to_27cm","soil_moisture_27_to_81cm"
  
  use *FUNCTION* to get corresponding time, will return a string array:
  getMeteoTime();
*/

//////// variables
float[] dir_everest, vel_everest;

//////// setup
void setup() {
  //////// basic layout
  pixelDensity( 2 );
  size( 1280, 720 );
  background( 255 );
  //////// access hourly data
  //meteo_data = loadMeteoJson( 64.15, -21.94, 3, "temperature_2m" );    // reykjavik
  //meteo_data = loadMeteoJson( -41.29, 174.78, 3, "temperature_2m" );    // wellington
  //meteo_data = loadMeteoJson( 47.07, 15.44, 3, "temperature_2m" );    // graz
  //meteo_data = loadMeteoJson( 47.07, 15.44, 1, "wind_speed_10m" );
  //meteo_data = loadMeteoJson( 47.07, 15.44, 7, "precipitation" );
  //meteo_data = loadMeteoJson( 47.07, 15.44, 7, "precipitation_probability" );
  //////// print/display gathered data
  //printArray( meteo_data );
  //printArray( getMeteoTime() );
  //simpleDemo( meteo_data );
  dir_everest = loadMeteoJson( 27.988333, 86.925278, 7, "wind_direction_10m" );    // mount everest
  vel_everest = loadMeteoJson( 27.988333, 86.925278, 7, "wind_speed_10m" );    // mount everest
////////////////////////////////////////////////////////////////
}

//////// draw
void draw() {
  background( 255 );
  translate( width/2, height/2 );
  dispWind( dir_everest, vel_everest );
}

//////// interaction
void keyReleased() {
  if( keyCode==120 ) savePng();    // f9
}

//////// function
void dispWind( float[] dirs, float[] vels ) {
  for( int id=0; id<dirs.length; id++ ) {                         // loop over all entries
    pushMatrix();                                                 // save current transforms
    float dir = dirs[ id ];                                       // now assign data according to array-id
    float rot = radians( dir );
    rotate( rot );
    float vel = vels[ id ];                                       // now assign data according to array-id
    float len = vel * 32;
    line( 0, 0, 0, len );
    popMatrix();                                                  // reset to previous transforms
  }                                                               // end loop
}
