
//////// DesCode
//////// richard.dank@fh-joanneum.at
//////// http://richdank.com/theory/descode/
//////// path step 4

/*
  variable-documentation and data from:
  https://open-meteo.com/en/docs
  
  use *FUNCTION* to gather weather data, will return float array:
  loadMeteoJson( latitude, longitude, days, weather variables );
  
  : latitude (float)
  -90 to 90, south to north, eg. 47.07 for graz
  : longitude (float)
  -180 to 180, west to east, eg. 15.44 for graz
  : days (int)
  1 to 16
  : most common weather variables (string)
  "temperature_2m","relative_humidity_2m","dew_point_2m","apparent_temperature",
  "precipitation_probability","precipitation","rain","showers","snowfall",
  "weather_code","pressure_msl","surface_pressure","cloud_cover",
  "cloud_cover_low","cloud_cover_mid","snow_depth","cloud_cover_high",
  "visibility","evapotranspiration","et0_fao_evapotranspiration",
  "vapour_pressure_deficit","wind_speed_10m","wind_speed_80m","wind_speed_120m",
  "wind_speed_180m","wind_direction_10m","wind_direction_80m",
  "wind_direction_120m","wind_direction_180m","wind_gusts_10m","temperature_80m",
  "temperature_120m","temperature_180m","soil_temperature_0cm",
  "soil_temperature_6cm","soil_temperature_18cm","soil_temperature_54cm",
  "soil_moisture_0_to_1cm","soil_moisture_1_to_3cm","soil_moisture_3_to_9cm",
  "soil_moisture_9_to_27cm","soil_moisture_27_to_81cm"
  
  use *FUNCTION* to get corresponding time, will return a string array:
  getMeteoTime();
*/

//////// variables
float[] dir_reykjavik, vel_reykjavik;
float[] dir_everest, vel_everest;
float[] dir_wellington, vel_wellington;

//////// setup
void setup() {
  //////// basic layout
  pixelDensity( 2 );
  size( 1280, 720 );
  background( 255 );
  //////// access hourly data
  //meteo_data = loadMeteoJson( 64.15, -21.94, 3, "temperature_2m" );    // reykjavik
  //meteo_data = loadMeteoJson( -41.29, 174.78, 3, "temperature_2m" );    // wellington
  //meteo_data = loadMeteoJson( 47.07, 15.44, 3, "temperature_2m" );    // graz
  //meteo_data = loadMeteoJson( 47.07, 15.44, 1, "wind_speed_10m" );
  //meteo_data = loadMeteoJson( 47.07, 15.44, 7, "precipitation" );
  //meteo_data = loadMeteoJson( 47.07, 15.44, 7, "precipitation_probability" );
  //////// print/display gathered data
  //printArray( meteo_data );
  //printArray( getMeteoTime() );
  //simpleDemo( meteo_data );
  dir_reykjavik = loadMeteoJson( 64.15, -21.94, 7, "wind_direction_10m" );    // reykjavik
  vel_reykjavik = loadMeteoJson( 64.15, -21.94, 7, "wind_speed_10m" );    //reykjavik
  dir_everest = loadMeteoJson( 27.988333, 86.925278, 7, "wind_direction_10m" );    // mount everest
  vel_everest = loadMeteoJson( 27.988333, 86.925278, 7, "wind_speed_10m" );    // mount everest
  dir_wellington = loadMeteoJson( -41.29, 174.78, 7, "wind_direction_10m" );    // wellington
  vel_wellington = loadMeteoJson( -41.29, 174.78, 7, "wind_speed_10m" );    // wellington
////////////////////////////////////////////////////////////////
}

//////// draw
void draw() {
  background( 255 );
  translate( width/2, height/2 );
  stroke( 255, 0, 0 );                                            // set color
  dispWind( dir_reykjavik, vel_reykjavik );                       // call function for reykjavik
  resetMatrix();                                                  // reset coordinate-system
  translate( width/2, height/2 );                                 // move agein to the center
  stroke( 0, 255, 0 );                                            // set color
  dispWind( dir_everest, vel_everest );
  resetMatrix();                                                  // reset coordinate-system
  translate( width/2, height/2 );                                 // move agein to the center
  stroke( 0, 0, 255 );                                            // set color
  dispWind( dir_wellington, vel_wellington );                     // call function for wellington
}

//////// interaction
void keyReleased() {
  if( keyCode==120 ) savePng();    // f9
}

//////// function
void dispWind( float[] dirs, float[] vels ) {
  int start = (int)map(mouseX,width,0,0,dirs.length);
  for( int id=start; id<dirs.length; id++ ) {
    //pushMatrix();
    float dir = dirs[ id ];
    float rot = radians( dir );
    rotate( rot );
    float vel = vels[ id ];
    float len = vel * map(mouseY,0,height,0,8);
    strokeWeight( 1 );
    line( 0, 0, 0, len );
    strokeWeight( 2 );
    point( 0, 0 );
    //popMatrix();
    translate( 0, len );
    rotate( -rot );
  }
}
